//////////////////////////////////////////////////////////////////////////////
//             ___________  /                                               //
//  Raymond   / _________/  /  Capper version 0.01 beta (general release)   //
//   Sheh    / /      __    /  for Palm OS 5.0 and above                    //
//          / /___  _/ /    /                                               //
//         /_____ \ \_/     /  Copyright (C) 2003 Raymond Sheh              //
//        __     \ \        /                                               //
//       / / ____ \ \       /  capper@raybot.net                            //
//      /_/ /____\ \_\     /  http://capper.raybot.net                     //
//                          /                                    2003-03-30 //
//////////////////////////////////////////////////////////////////////////////
//
// This file is part of Capper version 0.01 beta (general release)
// Copyright (C) 2003  Raymond Sheh
// Portions Copyright (C) 2002 Yih-Chun Hu
//
// Capper is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Capper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Capper (LICENCE.txt); if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//

#include <PalmOS.h>
#include <DataMgr.h>
#include <StringMgr.h>
#include "capper.h"

#define MAX_FILES 20

//Creator ID of Capper. This 4 character string uniquely identifies
//Capper and has been registered on the official PalmOS developers'
//website at http://dev.palmos.com/creatorid . If you modify Capper 
//significantly, PLEASE change this (and register your creator ID at 
//http://dev.palmos.com/creatorid ) to avoid problems. 
#define appCreatorID 'CapR'

#define PREFERENCE_ENABLED 1
#define PREFERENCE_DBARRAY 3
#define PREFERENCE_CNARRAY 4
#define PREFERENCE_CURTYPE 2

//Defines to make life a little easier ...
#define REG(x) SysNotifyRegister(cn,db,x,NULL,sysNotifyNormalPriority,NULL)
#define UNREG(x) SysNotifyUnregister(cn,db,x,NULL)

//Standard functions required by PalmOS
UInt32 PilotMain(UInt16 cmd, 
                 MemPtr cmdPBP,
                 UInt16 launchFlags __attribute__ ((unused)));
static void EventLoop(void);
static Boolean MainEventHandler(EventType*);

//Other functions 
static void *getControl(UInt16 ctlID);     //Gets form object based on control ID
static Boolean getEnabled();               //Checks if Capper is enabled
static void setEnabled(Boolean);           //Sets enabled state of Capper. Note that 
                                           //  this does NOT unregister OS notifications, 
                                           //remember to run EnableCapper() if this changes.
static void setCurrentLabel(UInt16 index); //Sets label to display which 
                                           //  cap mode is current (0=none)
void EnableCapper();                       //Enables Capper





static void *getControl(UInt16 ctlID) {
  return FrmGetObjectPtr(FrmGetActiveForm(), 
                         FrmGetObjectIndex(FrmGetActiveForm(), ctlID));
}


UInt32 PilotMain(UInt16 cmd, 
                 MemPtr cmdPBP,
                 UInt16 launchFlags __attribute__ ((unused)))
{
  if(cmd == sysAppLaunchCmdNormalLaunch) 
  {
    UInt32 dwROMVer;
    FtrGet(sysFtrCreator, sysFtrNumROMVersion, &dwROMVer);
    //Remember, Capper is only compatible with palmOS5 or above
    //(the stroke start/end notifications were different in 
    //previous versions).
    if (sysGetROMVerMajor(dwROMVer) < 5) 
    {
      if(sysGetROMVerMajor(dwROMVer) == 1)
      {
        AppLaunchWithCommand(sysFileCDefaultApp, 
                             sysAppLaunchCmdNormalLaunch, 
                             NULL);
      }
      return sysErrRomIncompatible;
    }
    FrmGotoForm(frmMain);
    EventLoop();
  }
  else if(cmd == sysAppLaunchCmdSystemReset)
  {
    PrefSetAppPreferences(appCreatorID, PREFERENCE_DBARRAY, 0, NULL, 0, true);
    PrefSetAppPreferences(appCreatorID, PREFERENCE_CNARRAY, 0, NULL, 0, true);
    EnableCapper();
  }
  else if(cmd == sysAppLaunchCmdNotify) 
  {
    SysNotifyParamType *np = (SysNotifyParamType *)cmdPBP;
    SysNotifyPenStrokeType *psp = (SysNotifyPenStrokeType *)np->notifyDetailsP;
    UInt16 numAreas, i;
    const SilkscreenAreaType *Areas = EvtGetSilkscreenAreaList(&numAreas);
    RectangleType rect;
    int ret;
    short sz;
    sz = sizeof(ret);
    if (PrefGetAppPreferences(appCreatorID, 
                              PREFERENCE_CURTYPE, 
                              &ret, 
                              &sz, 
                              true) == noPreferenceFound)
    {
      ret = btnType1;
    }
    switch(np->notifyType) 
    {
      case sysNotifyProcessPenStrokeEvent:
      {
        for (i=0; i<numAreas; i++)
        {
          if (
               Areas[i].areaType == silkscreenRectGraffiti 
               &&
               Areas[i].index == alphaGraffitiSilkscreenArea
             )
          {
            break;
          }
        }
        if (i == numAreas)
        {
          break;
        }
        rect.extent.x  = Areas[i].bounds.extent.x >> 1;
        rect.topLeft.x = Areas[i].bounds.topLeft.x + rect.extent.x;
        rect.topLeft.y = Areas[i].bounds.topLeft.y;
        rect.extent.y  = Areas[i].bounds.extent.y;
        if (
             (
               ret == btnType1 //Cap if start in alpha area and end anywhere else
               && 
               RctPtInRectangle(psp->startPt.x, psp->startPt.y, &(Areas[i].bounds)) 
               &&
               !RctPtInRectangle(psp->endPt.x, psp->endPt.y, &(Areas[i].bounds)) 
             )
             ||
             (
               ret == btnType2 //Cap if start in alpha area and end in number area
               && 
               psp->endPt.x > (Areas[i].bounds.topLeft.x + Areas[i].bounds.extent.x)
             )
             ||
             (
               ret == btnType3 //Cap if start and end within rectangle defined above
               && 
               RctPtInRectangle(psp->startPt.x, psp->startPt.y, &rect) 
               &&
               RctPtInRectangle(psp->endPt.x, psp->endPt.y, &rect) 
             )
           )
        {
          //If the cap method is based on start/end area (and the start/end 
          //criteria are satisfied) ...
          Boolean cl, nl, as; // caps, num, auto
          UInt16  sh;
          GrfGetState(&cl, &nl, &sh, &as);
          if (!cl && !sh && !as)
          {
            GrfSetState(cl, nl, 1);
          }
        }
        else if (ret == btnType4)
        {
          //cap stroke if any points lie in the number area.
          //This routine DOES NOT WORK so the button to select it has been removed
          //from the user interface. I'm still trying to figure out how to get it 
          //working. If you DO get it working, please do tell me (but check 
          //http://capper.raybot.net for a newer version which might have fixed it!). 
          UInt16 sh, numPts;
          int startPtX, capLine;
          Boolean cl, nl, as;
          PointType curPt;
          GrfGetState(&cl, &nl, &sh, &as);
          if (!cl && !sh && !as)
          {
            GrfGetNumPoints(&numPts);
            capLine = (int)(Areas[i].bounds.topLeft.x) + (int)(Areas[i].bounds.extent.x);
            startPtX = (int)(psp->startPt.x);
            for (i = 0; i < numPts; i ++)
            {
              GrfGetPoint(i, &curPt);
              if ((int)(curPt.x) + startPtX > capLine)
              {
                GrfGetState(&cl, &nl, &sh, &as);
                if (!cl && !sh && !as)
                {
                  GrfSetState(cl, nl, 1);
                }
                i = numPts;
              }
            }
          }
        }
        break;
      }
      default:
      {
        //... nothing here ...
        break;
      }
    }
  }
  return 0;
}


static void EventLoop(void)
{
  EventType event;
  do 
  {
    EvtGetEvent(&event, evtWaitForever);
    if(SysHandleEvent(&event)) 
    {
      continue;
    }
    if(event.eType == frmLoadEvent) 
    {
      Int32 formID = event.data.frmLoad.formID;
      FormPtr pForm = FrmInitForm(formID);
      FrmSetActiveForm(pForm);
      switch(formID) 
      {
        case frmMain:
        {
          FrmSetEventHandler(pForm, MainEventHandler);
          break;
        }
      }
    }
    FrmDispatchEvent(&event);
  }
  while(event.eType != appStopEvent);
  FrmCloseAllForms();
}



static Boolean MainEventHandler(EventType *event) 
{
  switch (event->eType) 
  {
    case frmOpenEvent:
    {
      CtlSetValue(getControl(cbxEnabled), getEnabled());
      if (event->data.frmOpen.formID == frmMain)
      {
        EnableCapper();
      }
      if (getEnabled())
      {
        int ret;
        short sz;
        sz = sizeof(ret);
        if (PrefGetAppPreferences(appCreatorID, PREFERENCE_CURTYPE, &ret, &sz, true) == noPreferenceFound)
        {
          ret = btnType1;
        }
        setCurrentLabel((UInt16)(ret - (int)btnType1 + 1));
      }
      else
      {
        setCurrentLabel((UInt16)0);
      }
      FrmDrawForm(FrmGetActiveForm());
      return true;
      break;
    }
    case ctlSelectEvent:
    {
      if (event->data.ctlEnter.controlID == cbxEnabled) 
      {
        setEnabled(CtlGetValue(getControl(cbxEnabled)));
        EnableCapper();
        return true;
      }
      else if (event->data.ctlEnter.controlID == btnAbout)
      {
        FormPtr aboutFrmPtr;
        aboutFrmPtr = FrmInitForm(frmAbout);
        FrmDoDialog(aboutFrmPtr);
      }
      else if (event->data.ctlEnter.controlID == btnReadme)
      {
        FormPtr readmeFrmPtr;
        readmeFrmPtr = FrmInitForm(frmReadme);
        FrmDoDialog(readmeFrmPtr);
      }
      else if (event->data.ctlEnter.controlID == btnType1)
      {
        int curType = btnType1;
        PrefSetAppPreferences(appCreatorID, PREFERENCE_CURTYPE, 0, &curType, sizeof(curType), true);
        if (getEnabled())
        {
          setCurrentLabel((UInt16)1);
        }
      }
      else if (event->data.ctlEnter.controlID == btnType2)
      {
        int curType = btnType2;
        PrefSetAppPreferences(appCreatorID, PREFERENCE_CURTYPE, 0, &curType, sizeof(curType), true);
        if (getEnabled())
        {
          setCurrentLabel((UInt16)2);
        }
      }
      else if (event->data.ctlEnter.controlID == btnType3)
      {
        int curType = btnType3;
        PrefSetAppPreferences(appCreatorID, PREFERENCE_CURTYPE, 0, &curType, sizeof(curType), true);
        if (getEnabled())
        {
          setCurrentLabel((UInt16)3);
        }
      }
      else if (event->data.ctlEnter.controlID == btnType4)
      {
        int curType = btnType4;
        PrefSetAppPreferences(appCreatorID, PREFERENCE_CURTYPE, 0, &curType, sizeof(curType), true);
        if (getEnabled())
        {
          setCurrentLabel((UInt16)4);
        }
      }
      break;
    }
    default: 
    {
      break;
    }
  }
  return false;
}



static Boolean getEnabled() 
{
  short ret, sz;
  sz = sizeof(ret);
  if (PrefGetAppPreferences(appCreatorID, 
                            PREFERENCE_ENABLED, 
                            &ret, 
                            &sz, 
                            true) == noPreferenceFound) 
  {
    ret = false;
    setEnabled(false);
  }
  return ret;
}



static void setEnabled(Boolean enabled) 
{
  int en = enabled;
  PrefSetAppPreferences(appCreatorID, 
                        PREFERENCE_ENABLED, 
                        0, 
                        &en, 
                        sizeof(en),
                        true);
  if (en)
  {
    int ret;
    short sz;
    sz = sizeof(ret);
    if (PrefGetAppPreferences(appCreatorID, 
                              PREFERENCE_CURTYPE, 
                              &ret, 
                              &sz, 
                              true) == noPreferenceFound)
    {
      ret = btnType1;
    }
    switch(ret)
    {
      case btnType1:
      {
        setCurrentLabel((UInt16)1);
        break;
      }
      case btnType2:
      {
        setCurrentLabel((UInt16)2);
        break;
      }
      case btnType3:
      {
        setCurrentLabel((UInt16)3);
        break;
      }
      case btnType4:
      {
        setCurrentLabel((UInt16)4);
        break;
      }
    }
  }
  else
  {
    setCurrentLabel((UInt16)0);
  }
}



static void setCurrentLabel(UInt16 index)
{
  FormType  *frm;
  FieldType *fldType;
  MemHandle memHandle;
  
  frm = FrmGetActiveForm();
  fldType = (FieldType *)FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, lblCurrent));
  memHandle = MemHandleNew(32);
  SysStringByIndex(strTypes, index, MemHandleLock(memHandle), 32); MemHandleUnlock(memHandle);
  FldSetTextHandle(fldType, memHandle);        
  FldDrawField(fldType);
}



void EnableCapper()
{
  UInt16 cn;
  LocalID db;
  
  SysCurAppDatabase(&cn, &db);
  if(getEnabled()) 
  {
    REG(sysNotifyProcessPenStrokeEvent);
  } 
  else 
  {
    UNREG(sysNotifyProcessPenStrokeEvent);
  }
}
